-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end
 
function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.counterLT = 0
      self.counterST = 0   
    end
    
    self.counterResult:LinkToTarget("victory")
    self.stopAttLT:LinkToTarget("stopAttackLt")
    self.stopAttST:LinkToTarget("stopAttackSt")
  end
  
  if self.counterLT == 3 then
    self.counterResult:TriggerAllTargets()
    self.stopAttLT:TriggerAllTargets()
    self.counterLT = 0
  end
  
  if self.counterST == 3 then
    self.counterResult:TriggerAllTargets()
    self.stopAttST:TriggerAllTargets()
    MarkMainGoal(self)
    self.counterST = 0
  end
  
end
 
function OnTrigger(self, source, target)
  if target == "lTCounter" then
    self.counterLT = self.counterLT + 1
  elseif target == "sTCounter" then
    self.counterST = self.counterST + 1
  end
end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("largeTown"):GetPosition().x
  gPosY = Game:GetEntity("largeTown"):GetPosition().y

  self.p0:SetQuestPosition('D2G_GOAL_3', gPosX, gPosY)
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.loaded = true
	  self.counterLT = ar:Read()
    self.counterST = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.counterLT)
    ar:Write(self.counterST)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("lTCounter")
  self:AddTriggerTarget("sTCounter")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("counterResult")
  self:AddTriggerSource("stopAttLT")
  self:AddTriggerSource("stopAttST")
end
